# OBGYN Research & Collaboration Platform

A comprehensive web-based platform for obstetrics and gynecology research collaboration, documentation, and global networking.

**Presented to Prof. Hesham Al Inany – Ganna Research Center**

## 🌟 Features

### Core Functionality
- **User Management**: Multi-role system (Super Admin, Institution Admin, Researcher, Guest)
- **Research Documentation**: Create, manage, and version control research studies
- **Global Networking**: LinkedIn-style professional networking for researchers
- **Collaboration Tools**: Team-based study management with role assignments
- **Real-time Messaging**: Integrated chat system with file sharing
- **Publication Hub**: Share and discover published research
- **Institution Management**: Hierarchical organization structure
- **Advanced Search**: Filter by specialty, country, research topic, and more
- **Security & Compliance**: 2FA, encryption, audit logs, GDPR-compliant

### Key Modules
1. **User Roles & Permissions** - RBAC system with granular access control
2. **Admin Dashboard** - Centralized control panel for platform management
3. **Research Documentation** - Comprehensive study management tools
4. **Researcher Networking** - Profile pages, connections, followers
5. **Study Collaboration** - Multi-investigator research projects
6. **Publication System** - Share and moderate research publications
7. **Communication** - Real-time chat with contact approval workflow
8. **Search & Discovery** - Advanced filtering and recommendations
9. **CMS** - Dynamic content management for public pages
10. **Analytics** - Platform statistics and reporting

## 📋 Requirements

- **Web Server**: Apache 2.4+ (XAMPP recommended)
- **PHP**: 7.4 or higher
- **Database**: MySQL 8.0+ or MariaDB 10.3+
- **Extensions**: PDO, PDO_MySQL, OpenSSL, mbstring, fileinfo

## 🚀 Installation

### Step 1: Setup XAMPP
1. Install XAMPP from https://www.apachefriends.org/
2. Start Apache and MySQL services

### Step 2: Clone/Copy Files
The project is already in: `D:\Coding\xampp\htdocs\obgyn-research-platform\`

### Step 3: Create Database
1. Open phpMyAdmin: http://localhost/phpmyadmin
2. Create a new database named: `obgyn_research_platform`
3. Import the schema:
   - Click on the database
   - Go to "Import" tab
   - Choose file: `database/schema.sql`
   - Click "Go"

### Step 4: Configure Database Connection
Edit `config/database.php` if needed (default settings):
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'obgyn_research_platform');
```

### Step 5: Set Permissions
Ensure the following directories are writable:
- `assets/uploads/`
- `assets/uploads/documents/`
- `assets/uploads/profiles/`
- `assets/uploads/studies/`

### Step 6: Access the Platform
Open your browser and navigate to:
```
http://localhost/obgyn-research-platform/
```

## 👤 Default Admin Account

After installation, create the first admin account by registering through the website, then manually update the database:

```sql
-- Update user role to Super Admin
UPDATE users SET role_id = 1, status = 'active', email_verified = 1 
WHERE email = 'your-email@example.com';
```

## 📁 Project Structure

```
obgyn-research-platform/
├── admin/              # Admin panel pages
├── api/                # API endpoints
├── assets/             # Static assets
│   ├── css/           # Stylesheets
│   ├── js/            # JavaScript files
│   ├── images/        # Images
│   └── uploads/       # User uploads
├── config/             # Configuration files
│   ├── config.php     # Main configuration
│   └── database.php   # Database connection
├── database/           # Database schema
│   └── schema.sql     # SQL schema file
├── includes/           # Core PHP includes
│   ├── auth.php       # Authentication functions
│   ├── functions.php  # Helper functions
│   ├── rbac.php       # Role-based access control
│   └── security.php   # Security functions
├── public/             # Public pages
├── researcher/         # Researcher dashboard
├── templates/          # Page templates
│   ├── header.php     # Header template
│   └── footer.php     # Footer template
├── index.php           # Home page
├── login.php           # Login page
├── register.php        # Registration page
├── logout.php          # Logout handler
└── README.md           # This file
```

## 🔒 Security Features

- **Password Hashing**: Bcrypt with cost factor 12
- **CSRF Protection**: Token-based validation
- **SQL Injection Prevention**: Prepared statements
- **XSS Protection**: Input sanitization and output escaping
- **Rate Limiting**: Login attempt throttling
- **2FA Support**: Two-factor authentication
- **Session Security**: Secure session management
- **File Upload Validation**: Type and size restrictions
- **Audit Logging**: Complete activity tracking

## 🛠️ Configuration

### Email Settings
Edit `config/config.php` to configure email:
```php
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-app-password');
```

### File Upload Limits
Adjust in `config/config.php`:
```php
define('MAX_FILE_SIZE', 10485760); // 10MB
define('ALLOWED_FILE_TYPES', ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'jpg', 'jpeg', 'png']);
```

## 📊 Database Schema

The platform uses 30+ tables organized into modules:
- User Management (users, roles, permissions)
- Researcher Profiles
- Institutions
- Research Studies
- Publications
- Networking (connections, followers)
- Messaging (chat rooms, messages)
- Notifications
- CMS Content
- Audit Logs
- Analytics

## 🌐 Browser Support

- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

## 📝 Usage Guide

### For Researchers
1. Register and verify your email
2. Complete your profile with specialization and institution
3. Browse and connect with other researchers
4. Create or join collaborative studies
5. Upload research documents
6. Share publications
7. Communicate via integrated chat

### For Institution Admins
1. Register your institution
2. Invite team members
3. Manage local research groups
4. Review and approve studies
5. Track institutional performance

### For Super Admins
1. Access admin dashboard
2. Manage all users and permissions
3. Moderate content and studies
4. Review audit logs
5. Configure platform settings
6. Generate analytics reports

## 🔧 Troubleshooting

### Database Connection Error
- Verify MySQL is running in XAMPP
- Check database credentials in `config/database.php`
- Ensure database exists

### File Upload Issues
- Check folder permissions (755 or 777)
- Verify `upload_max_filesize` in php.ini
- Check `post_max_size` in php.ini

### Email Not Sending
- Configure SMTP settings correctly
- Use app-specific password for Gmail
- Check firewall settings

## 📈 Future Enhancements

- AI-powered researcher recommendations
- Advanced analytics dashboard
- Mobile application
- Video conferencing integration
- Automated literature review tools
- Grant management system
- Conference management module
- Peer review workflow

## 🤝 Support

For technical support or questions:
- Email: admin@obgynresearch.com
- Documentation: Available in `/public/help.php`

## 📄 License

Proprietary - Ganna Research Center
All rights reserved.

## 👥 Credits

Developed for Prof. Hesham Al Inany – Ganna Research Center
Platform Version: 1.0
Release Date: 2025

---

**Note**: This is a production-ready platform. Ensure all security configurations are properly set before deploying to a live server.
